<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tentang;
use App\Models\Administrator;
use App\Models\Achievement;
use Yajra\DataTables\DataTables;
use App\Models\Portofolio;
use App\Models\Testimoni;
use App\Models\Skill;
use App\Models\Experience;
use App\Models\Education;
use App\Models\Blog;
use Session;
class Putcontroller extends Controller
{
    //
    public function home(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/';

        $file = $request->file('favicon');
        $file2 = $request->file('foto_home');

        if($file == null || $file == ''){
            if($file2 == null || $file2 == ''){
                $data = [
                    'judul_website' => $request->judul_website,
                    'logo_nama' => $request->logo_nama,
                    'nama' => $request->nama,
                    'profesi' => $request->profesi,
                    'telepon' => $request->telepon,
                    'email' => $request->email,
                    'alamat' => $request->alamat
                ];
            } else {
                $namafile2 = time().'_'.$file2->getClientOriginalName();
                $file2->move($tujuan_upload,$namafile2);

                $data = [
                    'foto_home' => $namafile2,
                    'judul_website' => $request->judul_website,
                    'logo_nama' => $request->logo_nama,
                    'nama' => $request->nama,
                    'profesi' => $request->profesi,
                    'telepon' => $request->telepon,
                    'email' => $request->email,
                    'alamat' => $request->alamat
                ];
            }
        } else {
            if($file2 == null || $file2 == ''){
                $namafile = time().'_'.$file->getClientOriginalName();
                $file->move($tujuan_upload,$namafile);
                
                $data = [
                    'favicon' => $namafile,
                    'judul_website' => $request->judul_website,
                    'logo_nama' => $request->logo_nama,
                    'nama' => $request->nama,
                    'profesi' => $request->profesi,
                    'telepon' => $request->telepon,
                    'email' => $request->email,
                    'alamat' => $request->alamat
                ];
            } else {
                $namafile2 = time().'_'.$file2->getClientOriginalName();
                $file2->move($tujuan_upload,$namafile2);
                $namafile = time().'_'.$file->getClientOriginalName();
                $file->move($tujuan_upload,$namafile);

                $data = [
                    'favicon' => $namafile,
                    'foto_home' => $namafile2,
                    'judul_website' => $request->judul_website,
                    'logo_nama' => $request->logo_nama,
                    'nama' => $request->nama,
                    'profesi' => $request->profesi,
                    'telepon' => $request->telepon,
                    'email' => $request->email,
                    'alamat' => $request->alamat
                ];
            }
        }
        Tentang::where('id', $request->id)->update($data);
        return back()->with(['info' => 'Data berhasil diupdate']);
    }
    public function achievementedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Achievement::find($id);
        return response()->json(['data' => $data]);
    }
    public function achievementupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $tujuan_upload = 'mystyle/image/prestasi';

        $file = $request->file('gambar');

        if($file == null || $file == ''){
            $data = [
                'nama' => $request->judul
            ];
        } else{
            $namafile = time().'_'.$file->getClientOriginalName();
            $file->move($tujuan_upload,$namafile);

            $data = [
                'foto' => $namafile,
                'nama' => $request->judul
            ];
        }
        Achievement::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil diupdate']);
    }
    public function portfolioedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Portofolio::find($id);
        return response()->json(['data' => $data]);
    }
    public function portfolioupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $tujuan_upload = 'mystyle/image/portofolio';

        $file = $request->file('gambar');

        if($file == null || $file == ''){
            $data = [
                'judul' => $request->judul,
                'link' => $request->linkupdate
            ];
        } else{
            $namafile = time().'_'.$file->getClientOriginalName();
            $file->move($tujuan_upload,$namafile);

            $data = [
                'thumbnail' => $namafile,
                'judul' => $request->judul,
                'link' => $request->linkupdate
            ];
        }
        Portofolio::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil diupdate']);
    }
    public function testimoniedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Testimoni::find($id);
        return response()->json(['data' => $data]);
    }
    public function testimoniupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $tujuan_upload = 'mystyle/image/testimoni';

        $file = $request->file('gambar');

        if($file == null || $file == ''){
            $data = [
                'pesan' => $request->pesanupdate,
                'nama' => $request->namaupdate,
                'title' => $request->titleupdate
            ];
        } else{
            $namafile = time().'_'.$file->getClientOriginalName();
            $file->move($tujuan_upload,$namafile);

            $data = [
                'foto' => $namafile,
                'pesan' => $request->pesanupdate,
                'nama' => $request->namaupdate,
                'title' => $request->titleupdate
            ];
        }
        Testimoni::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil diupdate']);
    }
    public function tentang(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/';

        $file2 = $request->file('foto_about');
        if($file2 == null || $file2 == ''){
            $data = [
                'link_blog' => $request->link_blog,
                'link_instagram' => $request->link_instagram,
                'link_twitter' => $request->link_twitter,
                'link_facebook' => $request->link_facebook,
                'link_linkedin' => $request->link_linkedin,
                'tentang' => $request->tentang,
                'link_cv' => $request->link_cv
            ];
        } else {
            $namafile2 = time().'_'.$file2->getClientOriginalName();
            $file2->move($tujuan_upload,$namafile2);

            $data = [
                'foto_about' => $namafile2,
                'link_blog' => $request->link_blog,
                'link_instagram' => $request->link_instagram,
                'link_twitter' => $request->link_twitter,
                'link_facebook' => $request->link_facebook,
                'link_linkedin' => $request->link_linkedin,
                'tentang' => $request->tentang,
                'link_cv' => $request->link_cv
            ];
        }
        Tentang::where('id', $request->id)->update($data);
        return back()->with(['info' => 'Data berhasil diupdate']);
    }
    public function skilledit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Skill::find($id);
        return response()->json(['data' => $data]);
    }
    public function skillupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'nama_skill' => $request->nama_skill_update,
            'persentase' => $request->persentase_update
        ];
        $id = $request->id_skill;
        Skill::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil ditambahkan']);
    }
    public function experienceedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Experience::find($id);
        return response()->json(['data' => $data]);
    }
    public function experienceupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'tanggal' => $request->tanggal_update,
            'nama' => $request->nama_update,
            'penyelenggara' => $request->penyelenggara_update,
            'keterangan' => $request->keterangan_update
        ];
        $id = $request->id_experience;
        Experience::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil ditambahkan']);
    }
    public function educationedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Education::find($id);
        return response()->json(['data' => $data]);
    }
    public function educationupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'tahun' => $request->tahun_update,
            'nama_sekolah' => $request->nama_sekolah_update,
            'jurusan' => $request->jurusan_update,
            'keterangan' => $request->keterangan_edu_update
        ];
        $id = $request->id_education;
        Education::find($id)->update($data);
        return back()->with(['info' => 'Data berhasil ditambahkan']);
    }
    public function blogedit(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $blog = Blog::find($request->id)->get();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'blog' => $blog
        ];
        return view('admin.editblog')->with($data);
    }
    public function blogupdate(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/blog';

        $file = $request->file('featured');
        if($file == null || $file == ''){
            $data = [
                'judul' => $request->judul_blog,
                'content' => $request->content,
                'author' => $request->author,
                'change' => $request->created_at
            ];
        } else{
            $namafile = time().'_'.$file->getClientOriginalName();
            $file->move($tujuan_upload,$namafile);

            $data = [
                'featured_image' => $namafile,
                'judul' => $request->judul_blog,
                'content' => $request->content,
                'author' => $request->author,
                'change' => $request->created_at
            ];
        }
        print_r($data);
        Blog::find($request->id_blog)->update($data);
        return redirect('/admin/blog')->with(['primary' => 'Data berhasil ditambahkan']);
    }
}
