<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Achievement;
use Yajra\DataTables\DataTables;
use App\Models\Portofolio;
use App\Models\Testimoni;
use App\Models\Skill;
use App\Models\Experience;
use App\Models\Education;
use App\Models\Blog;
use App\Models\Pesan;
use Session;

class Storecontroller extends Controller
{
    //
    public function achievement(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $tujuan_upload = 'mystyle/image/prestasi';

        $file = $request->file('foto');
        $namafile = time().'_'.$file->getClientOriginalName();
        $file->move($tujuan_upload,$namafile);

        $data = [
            'foto' => $namafile,
            'nama' => $request->nama
        ];
        Achievement::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function portfolio(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/portofolio';

        $file = $request->file('thumbnail');
        $namafile = time().'_'.$file->getClientOriginalName();
        $file->move($tujuan_upload,$namafile);

        $data = [
            'id_kategori' => $request->id_kategori,
            'thumbnail' => $namafile,
            'judul' => $request->judul,
            'link' => $request->link
        ];
        Portofolio::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function testimoni(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/testimoni';

        $file = $request->file('foto');
        $namafile = time().'_'.$file->getClientOriginalName();
        $file->move($tujuan_upload,$namafile);

        $data = [
            'foto' => $namafile,
            'pesan' => $request->pesan,
            'nama' => $request->nama,
            'title' => $request->title
        ];
        Testimoni::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function skill(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'nama_skill' => $request->nama_skill,
            'persentase' => $request->persentase
        ];
        Skill::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function experience(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'tanggal' => $request->tanggal,
            'nama' => $request->nama,
            'penyelenggara' => $request->penyelenggara,
            'keterangan' => $request->keterangan
        ];
        Experience::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function education(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $data = [
            'tahun' => $request->tahun,
            'nama_sekolah' => $request->nama_sekolah,
            'jurusan' => $request->jurusan,
            'keterangan' => $request->keterangan_edu
        ];
        Education::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
    public function blog(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }

        $tujuan_upload = 'mystyle/image/blog';

        $file = $request->file('featured');
        $namafile = time().'_'.$file->getClientOriginalName();
        $file->move($tujuan_upload,$namafile);

        $data = [
            'featured_image' => $namafile,
            'judul' => $request->judul_blog,
            'content' => $request->content,
            'author' => $request->author,
            'change' => $request->created_at,
            'view' => 0,
            'suka' => 0,
        ];
        Blog::create($data);
        return redirect('/admin/blog')->with(['primary' => 'Data berhasil ditambahkan']);
    }

    public function pesan(Request $request)
    {
        $data = [
            'nama' => $request->name,
            'email' => $request->email,
            'subject' => $request->subject,
            'whatsapp' => $request->Whataspp,
            'message' => $request->pesan
        ];
        Pesan::create($data);
        return back()->with(['primary' => 'Data berhasil ditambahkan']);
    }
}
