@extends('template.template')
@section('title','Blog')
@section('main')

<div class="main">
	<h2><strong>Blog</strong></h2>
	<hr>
	<a href="{{route('blogadd')}}" class="btn black mt-2">Tambah Data</a>
	<br><br>
	<div class="data-content">
		<div class=table-control>
			<table class="table table-home table-striped table-bordered" id="blog-table">
				<thead>
					<tr>
						<th>Featured Image</th>
						<th>Judul</th>
						<th>Author</th>
						<th>Suka</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection
@section('script')
	<script type="text/javascript">
		$(function(){
		    $('#blog-table').DataTable({
		      	processing : true,
		      	serverSide : true,
		      	responsive : true,
		      	ajax: "{{ route('blogjson') }}",
		      	columns: [
			        {data: 'image', name: 'image'},
			        {data: 'judul', name: 'judul'},
			        {data: 'author', name: 'author'},
			        {data: 'suka', name: 'suka'},
			        {data: 'aksi', name: 'aksi'}
		        ]
		    });
	  	});

	  	$(document).on('click', '.hapus', function(){
	      	let id = $(this).attr('id');
	      	$.ajax({
	        	url : "{{ route('blogdelete') }}",
	        	type : 'post',
	        	data : {
	          		id : id,
	          		'_token' : "{{ csrf_token() }}"
	        	},
	        	success: function(params){
		          	alert(params.text);
		          	window.location = "{{route('blog')}}"
		        },
	        	error: function(xhr){
	          		alert(xhr)
	        	}
	      	});
	    });
	</script>
@endsection