@extends('template.landing')
@section('title')
@section('main')
<style type="text/css">
	.header header{
	  transition: .5s;
	  background-color: #03192e;
	}
	.header h2 a{
	  text-decoration: none;
	  transition: .5s;
	  color: #ffa84a;
	  font-weight: bold;
	  text-shadow: 2px 2px 10px #ffa84a;
	}
	.header a.text-contact,
	section .text-contact{
	  transition: .5s;
	  background-color: #ffa84a;
	  color: #fff;
	  font-weight: bold;
	  text-decoration: none;
	  transition: .5s ease;
	}
	.header a.text-contact:hover,
	section .text-contact:hover{
	  transition: .5s;
	  filter: contrast(80%);
	}
	.header .cover-mode{
	  transition: .5s;
	  background-color: #fff;
	}
	.header .button-mode{
	  transition: .5s;
	  background-color: #ffa84a;
	}
	.header a.menu-item{
	  transition: .5s;
	  color: #fff;
	  text-decoration: none;
	}
	.header a.menu-item:hover{
	  transition: .5s;
	  opacity: 80%;
	}
	.header .bars{
	  transition: .5s;
	  width: 30px;
	  height: 4px;
	  background-color: #fff;
	  margin-top: 2.2px;
	  border-radius: 10px;
	}
	.header .menu-responsive{
	  transition: .5s;
	  height: calc(100vh - 10vh);
	  width: 100%;
	  top: 10vh;
	  background-color: #03192e;
	  font-size: 120%;
	  color: #fff;
	}
</style>
@foreach($blog as $b)
<div class="main">
	<div class="data-content">
		<div class="border pt-2 pb-2 ps-lg-5 pe-lg-5 ps-md-3 pe-md-3">
			<div class="top">
				<h2><strong>{{$b->judul}}</strong></h2>
				<br>
				<hr>
				<br>
				<div class="float-start col-6">
					<i class="fas fa-calendar me-2"></i><strong> <?= date('d/F/Y', strtotime($b->change)) ?> WIB</strong>
				</div>
				<div class="float-end col-6 text-end">
					<i class="fas fa-user-circle me-2"></i><strong> Author : {{$b->author}}</strong>
				</div>
				<div class="clearfix"></div>
				<img src="{{asset('mystyle/image/blog/'.$b->featured_image)}}" width="100%">
				<br>
				<i class="fas fa-eye me-1"></i> {{$b->view}} <i class="fas fa-heart ms-1 me-1"></i> {{$b->suka}}
				<hr class="mt-2 mb-2">
				<div>
					<?= "".$b->content."" ?>
				</div>
			</div>
		</div>
	</div>
</div>
@endforeach

@endsection